<?php

namespace Tygh\Api\Entities;

use Tygh\Api\Response;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

/**
 * Tests core API functionality via CURL
 */
class UsersTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Users
     */
    protected $_obejct;

    protected function setUp()
    {
        parent::setUp();

        $this->_obejct = new Users(array(
            'area' => 'A',
            'user_id' => '1',
            'user_type' => 'A',
            'tax_exempt' => 'N',
            'last_login' => '1343637055',
            'usergroup_ids' => array ( ),
            'order_ids' => array ( ),
            'act_as_user' => false,
            'this_login' => 1343652763,
            'password_change_timestamp' => 0,
            'company_id' => 0,
            'is_root' => 'Y',
            'referer' => '',
            'ip' => '192.168.1.111',
            'first_expire_check' => false
        ));
    }

    protected function tearDown()
    {
    }

    public static function setUpBeforeClass()
    {
        \Tygh\Registry::set('runtime.company_id', 0);
    }

    protected function usersDatset()
    {
        return array(
            'users.xml',
            'user_profiles.xml',
        );
    }

    /**
     *
     * @dataProvider providerIndex()
     * @datasetProvider usersDatset
     */
    public function testIndex($id, $params, $result)
    {
        $this->assertEquals($result, $this->_obejct->index($id, $params));
    }

    public function providerIndex()
    {
        $params = array (
            'page' => 1,
            'sort_order' => 'asc',
            'sort_by' => 'name',
            'items_per_page' => '10',
            'sort_order_rev' => 'desc',
            'total_items' => '4',
        );

        return array(
            // Get users list
            array('', array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'users' => array (
                        array (
                            'user_id' => '1',
                            'user_login' => 'admin',
                            'is_root' => 'Y',
                            'timestamp' => '1112556008',
                            'user_type' => 'A',
                            'status' => 'A',
                            'firstname' => 'Admin',
                            'lastname' => 'Admin',
                            'email' => 'admin@example.com',
                            'company' => 'Your company',
                            'company_id' => '0',
                            'company_name' => NULL,
                        ),                   
                        array (
                            'user_id' => '4',
                            'user_login' => 'admin2',
                            'is_root' => 'Y',
                            'timestamp' => '1112556008',
                            'user_type' => 'A',
                            'status' => 'A',
                            'firstname' => 'Admin2',
                            'lastname' => 'Admin2',
                            'email' => 'admin2@example.com',
                            'company' => 'Your company2',
                            'company_id' => '1',
                            'company_name' => 'Simtech',
                        ),                        
                        array (
                            'user_id' => '3',
                            'user_login' => 'customer',
                            'is_root' => 'N',
                            'timestamp' => '1116709280',
                            'user_type' => 'C',
                            'status' => 'A',
                            'firstname' => 'Customer',
                            'lastname' => 'Customer',
                            'email' => 'customer@example.com',
                            'company' => 'Simtech',
                            'company_id' => '1',
                            'company_name' => 'Simtech',
                        ),
                        array (
                            'user_id' => '5',
                            'user_login' => 'customer2',
                            'is_root' => 'N',
                            'timestamp' => '1116709280',
                            'user_type' => 'C',
                            'status' => 'A',
                            'firstname' => 'Customer2',
                            'lastname' => 'Customer2',
                            'email' => 'customer2@example.com',
                            'company' => 'Simtech',
                            'company_id' => '1',
                            'company_name' => 'Simtech',
                        ),                        
                    ),
                    'params' => $params,
                ),
            )),
            // Get 1 user list
            array(1, array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'user_id' => '1',
                    'user_login' => 'admin',
                    'is_root' => 'Y',
                    'timestamp' => '1112556008',
                    'user_type' => 'A',
                    'status' => 'A',
                    'firstname' => 'Admin',
                    'lastname' => 'Admin',
                    'email' => 'admin@example.com',
                    'company' => 'Your company',
                    'company_id' => '0',
                    'company_name' => NULL,
                ),
            )),
            // Test that filters worked
            array('', array('user_ids' => array(1, 5, 2)), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'users' => array (
                        array (
                            'user_id' => '1',
                            'user_login' => 'admin',
                            'is_root' => 'Y',
                            'timestamp' => '1112556008',
                            'user_type' => 'A',
                            'status' => 'A',
                            'firstname' => 'Admin',
                            'lastname' => 'Admin',
                            'email' => 'admin@example.com',
                            'company' => 'Your company',
                            'company_id' => '0',
                            'company_name' => NULL,
                        ),
                        array (
                            'user_id' => '5',
                            'user_login' => 'customer2',
                            'is_root' => 'N',
                            'timestamp' => '1116709280',
                            'user_type' => 'C',
                            'status' => 'A',
                            'firstname' => 'Customer2',
                            'lastname' => 'Customer2',
                            'email' => 'customer2@example.com',
                            'company' => 'Simtech',
                            'company_id' => '1',
                            'company_name' => 'Simtech',
                        ),
                    ),
                    'params' =>  array (
                        'user_ids' => array (
                            0 => 1,
                            1 => 5,
                            2 => 2,
                        ),
                        'user_id' => array (
                            0 => 1,
                            1 => 5,
                            2 => 2,
                        ),
                        'total_items' => 2,
                    ) + $params,
                ),
            )),
            array('', array('email' => 'admin@example.com'), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'users' => array (
                        0 => array (
                            'user_id' => '1',
                            'user_login' => 'admin',
                            'is_root' => 'Y',
                            'timestamp' => '1112556008',
                            'user_type' => 'A',
                            'status' => 'A',
                            'firstname' => 'Admin',
                            'lastname' => 'Admin',
                            'email' => 'admin@example.com',
                            'company' => 'Your company',
                            'company_id' => '0',
                            'company_name' => NULL,
                        ),
                    ),
                    'params' =>  array (
                        'email' => 'admin@example.com',
                        'page' => 1,
                        'total_items' => 1,
                    ) + $params,
                ),
            )),
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     * @datasetProvider usersDatset
     */
    public function testCreate($params, $result)
    {
        $this->assertEquals($result, $this->_obejct->create($params));
    }

    public function providerCreate()
    {
        return array(
            // Try create with empty data
            array(array(), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_required_field', array('[field]' => 'company_id'))
                ),
            )),
            // Try create user with duplicate email
            array(array(
                'user_login' => 'admin',
                'is_root' => 'Y',
                'timestamp' => '1112556008',
                'user_type' => 'A',
                'status' => 'A',
                'firstname' => 'Admin',
                'lastname' => 'Admin',
                'email' => 'admin@example.com',
                'company' => 'Your company',
                'company_id' => '0',
                'company_name' => NULL,
            ), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(),
            )),

            array(array(
                'user_login' => 'test',
                'is_root' => 'Y',
                'timestamp' => '1112556408',
                'user_type' => 'C',
                'status' => 'A',
                'firstname' => 'Admin',
                'lastname' => 'Admin',
                'email' => 'another@example.com',
                'company' => 'Your company',
                'company_id' => '1',
                'company_name' => NULL,
            ), array(
                'status' => Response::STATUS_CREATED,
                'data' => array(
                    'user_id' => 6,
                    'profile_id' => '4',
                ),
            )),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     * @datasetProvider usersDatset
     */
    public function testUpdate($id, $params, $result)
    {
        $this->assertEquals($this->_obejct->update($id, $params), $result);
    }

    public function providerUpdate()
    {
        return array(
            // Try update with empty id
            array('', array(
                'user_login' => 'test',
                'is_root' => 'Y',
                'timestamp' => '1112556008',
                'status' => 'D',
                'firstname' => 'Admin',
                'lastname' => 'Admin',
            ), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(),
            )),

            // Try update
            array(3, array(
                'user_login' => 'test',
                'is_root' => 'Y',
                'timestamp' => '1112556008',
                'status' => 'D',
                'firstname' => 'Admin',
                'lastname' => 'Admin',
            ), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'user_id' => 3,
                    'profile_id' => '2',
                ))
            ),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     * @datasetProvider usersDatset
     */
    public function testDelete($id, $result)
    {
        $this->assertEquals($this->_obejct->delete($id), $result);
    }

    public function providerDelete()
    {
        return array(
            // Try update with empty id
            array('', array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try update
            array(5, array(
                'status' => Response::STATUS_NO_CONTENT,
                'data' => array(),
            )),
        );
    }
}
